/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder.util;

import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ShaderPatternUtil {
    public static String convertToRegex(String pattern) {
        StringBuilder result = new StringBuilder();
        int currentPos = 0;
        while (currentPos < pattern.length()) {
            int closeBrace;
            int openBrace = pattern.indexOf(123, currentPos);
            if (openBrace == -1) {
                result.append(Pattern.quote(pattern.substring(currentPos)));
                break;
            }
            if (openBrace > currentPos) {
                result.append(Pattern.quote(pattern.substring(currentPos, openBrace)));
            }
            if ((closeBrace = ShaderPatternUtil.findMatchingCloseBrace(pattern, openBrace)) == -1) {
                result.append(Pattern.quote(pattern.substring(currentPos)));
                break;
            }
            String braceContent = pattern.substring(openBrace + 1, closeBrace);
            if ("version".equals(braceContent)) {
                result.append("\\d+(\\.\\d+)*");
            } else if ("all".equals(braceContent)) {
                result.append(".*");
            } else {
                result.append(braceContent);
            }
            currentPos = closeBrace + 1;
        }
        return result.toString();
    }

    public static int findMatchingCloseBrace(String text, int openBracePos) {
        int depth = 1;
        for (int i = openBracePos + 1; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchesPattern(String text, String patternStr) {
        if (patternStr.trim().isEmpty() || patternStr.startsWith("#")) {
            return false;
        }
        try {
            String regexPattern = ShaderPatternUtil.convertToRegex(patternStr);
            String finalPattern = "^" + regexPattern + "(\\.zip)?$";
            Pattern pattern = Pattern.compile(finalPattern, 2);
            Matcher matcher = pattern.matcher(text);
            return matcher.matches();
        }
        catch (PatternSyntaxException e) {
            String errorMsg = "Invalid pattern: " + patternStr + " - " + e.getMessage();
            IrisShaderFolder.LOGGER.error(errorMsg);
            if (IrisShaderFolder.debugLoggingEnabled) {
                IrisShaderFolder.LOGGER.debug("ERROR: " + errorMsg);
            }
            return false;
        }
    }

    public static void logDebug(String message) {
        if (IrisShaderFolder.debugLoggingEnabled) {
            IrisShaderFolder.LOGGER.info(message);
        }
    }
}

